/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 0.1.2                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006,2007,2008 COLLARD Christophe
 * copyright  2006,2007,2008 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2006,2007 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    cubic tensors-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type cubic tensors test
#endif

#if !defined(__CUBIC_TENSORS_TEST_H)
#define __CUBIC_TENSORS_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__PARAMETERS_H)
#include "parameters.h"
#endif

#if !defined(___VECTORS_H)
#include"MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include"MOL++/matrix.h"
#endif

#if !defined(___TENSOR4_H)
#include"MOL++/tensors4.h"
#endif

#if !defined(__ISOTROPIC_ELASTICITY_TENSORS_H)
#include"MateriOL++/isotropic elasticity tensors.h"
#endif

#if !defined(__CUBIC_TENSORS_H)
#include"MateriOL++/cubic tensors.h"
#endif

#if !defined(__AFFICHE_h)
#include "tests/affiche.h"
#endif

//#include "MateriOL++/MatOoLbox.h"
//#include "MOL++/conversion tools.h"


//================================
int test_cubic_tensor (int detail)
//================================
{
  bool result = true;

  long double lambda=60000, mu=40000;
  isotropic_elasticity_tensor<long double> C;
  C.Lame(lambda);
  C.Shear(mu);
  cubic_tensor<long double> Co (lambda+2*mu, mu,lambda);
  if (detail) affiche ("cubic tensor for isotropic materials", C==Co);
  else result *= (C==Co);

  long double C11=141600, C12=127400, C44=94200;
  cubic_tensor<long double> Cn(C11,C44,C12, "cubic tensor");
  tensor4<long double> T4(3);
  T4(1,1,1,1) = T4(2,2,2,2) = T4(3,3,3,3) = C11;
  T4(1,2,1,2) = T4(1,2,2,1) = T4(2,1,1,2) = T4(2,1,2,1) = T4(1,3,1,3) = T4(1,3,3,1) = T4(3,1,1,3) = T4(3,1,3,1) = T4(2,3,2,3) = T4(2,3,3,2) = T4(3,2,2,3) = T4(3,2,3,2) = C44;
  T4(1,1,2,2) = T4(2,2,1,1) = T4(1,1,3,3) = T4(3,3,1,1) = T4(2,2,3,3) = T4(3,3,2,2) = C12;

  vector<long double> v(3);
  v[1] = C11;
  v[2] = C44;
  v[3] = C12;
  cubic_tensor<long double> Cv(v, "cubic tensor");
  if (detail) affiche("constructors", T4==Cn && Cv==Cn);
  else result *= (T4==Cn && Cv==Cn);

  bool test = true;
  tensor4<long double> T;
  T = Cn;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  test *= (T(i,j,k,l) == Cn(i,j,k,l));
  if (detail) affiche ("cast conversion cubic_tensor -> tensor4", test);
  else result *= (test);

  cubic_tensor<long double> Ci;
  Ci = cubic_tensor<long double> (T);
  if (detail) affiche ("cast conversion tensor4 -> cubic_tensor", Cn==Ci);
  else result *= (Cn==Ci);

  if (detail) affiche ("elastic constants", Cn.elastic_constants() == v);
  else result *= (Cn.elastic_constants() == v);

  tensor4<long double> Id(3);
  Id = Id4s<long double> (3);
  if (detail) affiche ("inv", (Cn||Cn.inv()) == Id && (Cn.inv()||Cn) == Id);
  else result *= ((Cn||Cn.inv()) == Id && (Cn.inv()||Cn) == Id);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                   cubic tensor test passed \n";
  else cout << "                   cubic tensor test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
